VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CEventLog"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Public Enum enLOG_ERRORCODES
    logFILE_OPEN_FAILED = 9040  'Could not open specified event log.
    logWRITE_WITHOUT_CREATE     'Event log write operation attempted before
                                'log was created.
    logWRITE_WITHOUT_ENTRY      'Event log write operation attempted before
                                'log entry created.
    logWRITE_FAILED             'Event log write operation failed.
End Enum

Private m_hFile As Long         'Log file handle
Private m_sAppName As String    'Application Name
Private m_lThreadID As Long     'Application thread id

'Used to ensure the Create() method is called.
Private m_bIsCreated As Boolean

'True if there is a current log entry.
Private m_bIsEntryOpen As Boolean

'Some useful String Constants
Private Const WRITE_FAILED As String = "Event log write operation failed."
Private Const APP_NAME As String = "*AppName: "
Private Const THREAD_ID As String = "*ThreadID: "
Private Const TIME_STAMP As String = "*TimeStamp: "
Private Const ENTRY_TYPE As String = "*Entry Type: "
Private Const ENTRY_SEPARATOR As String = _
"**********************************************************************"

'****************************************************************
'Initialize the class
'****************************************************************
Private Sub Class_Initialize()
    m_bIsCreated = False
    m_bIsEntryOpen = False
End Sub

'****************************************************************
'Class Terminate
'****************************************************************
Private Sub Class_Terminate()
    Close m_hFile
End Sub

'****************************************************************
'Create the log file.  Set data members.
'****************************************************************
Friend Sub Create(sPath As String, _
                  sAppName As String, _
                  lAppThread As Long)
    
    On Error GoTo ErrorHandler
    m_hFile = FreeFile
    Open sPath For Append As #m_hFile
    
    m_sAppName = sAppName
    m_lThreadID = lAppThread
    m_bIsCreated = True
    
    Exit Sub

ErrorHandler:
    Dim sErr As String
    sErr = "Could not open specified event log." & vbCrLf & vbCrLf _
           & "System Error: " & Err.Number & " = " & Err.Description
    Err.Raise logFILE_OPEN_FAILED Or vbObjectError, "CEventLog.Create", sErr
    m_bIsCreated = False
End Sub

'****************************************************************
'Writes an entire entry to the log file.  If a previous entry
'is still open, then it is closed.
'****************************************************************
Public Sub WriteEntry(sLog As String)
    
    If m_bIsEntryOpen Then
        CloseEntry
    End If
    
    NewEntry
    WriteLn sLog
    CloseEntry

End Sub

'****************************************************************
'Writes a line to the log file.
'****************************************************************
Public Sub WriteLn(sLine As String)

    'Make sure the Create() method has been called.
    If Not m_bIsCreated Then
        Debug.Assert False 'Assert condition in debug mode
        Err.Raise logWRITE_WITHOUT_CREATE Or vbObjectError, _
                    "CEventLog.WriteLn()", _
                    "Event log write operation attempted before log was created."
    End If
    
    'Make sure NewEntry() method has been called.
    If Not m_bIsEntryOpen Then
        Debug.Assert False 'Assert condition in debug mode
        Err.Raise logWRITE_WITHOUT_ENTRY Or vbObjectError, _
                    "CEventLog.WriteLn()", _
                    "Event log write operation attempted before log entry created."
    End If
    
    PrivateWrite sLine
        
End Sub

'****************************************************************
'Creates a new entry in the log file.  Writes the log headers
'and sets various member variables.
'****************************************************************
Public Sub NewEntry()

    'Make sure the Create() method has been called.
    If Not m_bIsCreated Then
        Debug.Assert False 'Assert condition in debug mode
        Err.Raise logWRITE_WITHOUT_CREATE Or vbObjectError, "CEventLog.OpenEntry()", _
        "Event log write operation attempted before log was created."
    End If
    
    PrivateWrite ENTRY_SEPARATOR
    PrivateWrite APP_NAME & vbTab & m_sAppName
    PrivateWrite THREAD_ID & vbTab & m_lThreadID
    PrivateWrite TIME_STAMP & vbTab & Format(Now, "general date")
    PrivateWrite ENTRY_SEPARATOR
    m_bIsEntryOpen = True
    
End Sub

'****************************************************************
'Closes the log entry.
'****************************************************************
Public Sub CloseEntry()
    WriteLn ""
    m_bIsEntryOpen = False
End Sub

'****************************************************************
'Performs the actual write to the log file.
'****************************************************************
Private Sub PrivateWrite(sLine As String)
    On Error GoTo WriteError
    Print #m_hFile, sLine
    Exit Sub

WriteError:
    Dim sErrMsg As String
    sErrMsg = WRITE_FAILED & vbCrLf & "System Error: " & Err.Description
    Err.Raise logWRITE_FAILED Or vbObjectError, _
                "CEventLog.WriteLn()", sErrMsg
End Sub

